



/***********************************************************************************************
 *                                                                                             *
 *                  Example_2. ET-REMOTE MP3 COMMAND-Mode By Read Play Time                    *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *
 * Target MCU        : PIC18F8722 (ET-BASE PIC8722(ICD2))                                      *
 *                   : X-TAL : 10 MHz                                                          *
 *                   : CPU Clock = 40 MHz (x4)                                                 *                                                                  
 * Editor-Compiler   : CCS Version 4.120                                                       *
 *                                                                                             *
 *                                                                                             *
 * Port Interface    :  # MCU-18F8722 #                        # ET-REMOTE MP3 #               *
 *                      --------------                        -------------------              * 
 *                                                                                             *
 *       UART1       :  PORT RC6 = TX1          Connect              Tx                        *
 *                      PORT RC7 = RX1          Connect              Rx                        *
 *                      GND                     Connect              GND                       *
 *                      Baud Rate 9600                                                         *
 *                                                                                             *
 *                                                                                             *
  *              5V                                                                            *
 *             -+-                                                                             *
 *              |                                                                              *
 *              +------------------+                                                           *
 *              |                  |                                      -DIP SW. MODE        *
 *              |                  |                                       S1=ON,S2=ON         *
 *              |                  |                 ET-REMOTE MP3 V2     -DIP SW.CONFIG       *
 *       +------+------+           |               +-------------------+   S1=ON;S2=OFF        *
 *       |             |       +---+---+   +---+   |                   |   BR:9600             *
 *       |             |       |       |   |   |   |RS232(have-Max232) |                       *
 *       |             | RX1   |       |   |   |   |----+              |                       *
 *       |          RC7+-------|RxI RxO|<--|-+ +-->|*Rx||              |        /|             *   
 *       |             | TX1   |       |   | |     |   ||              |      /  |             *
 *       |          RC6+-------|TxI TxO|---+ +-----|*Tx||              +----||   |             *
 *       |             |       |       |           |   ||              |    || SP|             *
 *       |             |       |MAX232 |       +---+*G ||              +----||   |             *
 *       |             |       +---+---+       |   |----+   [Power]    |      \  |             *
 *       | PIC18F8722  |           |           |   |                   |        \|             * 
 *       +------+------+           |           |   |         G  5V     |                       *
 *              |                  |           |   +---------+---+-----+                       * 
 *              |                  |           |             |   |                             *
 *              +------------------+-----------+             |   +--->5V                       *
 *              |                                            |                                 *
 *            --+--                                        --+--                               *
 *             ---                                          ---                                *
 *              -                                            -                                 *
 *                                                                                             *
 * Test Operate    : For Test Program in Micro SD Card must have File Name 'A23_FT1.MP3' and   *
 *                   'A23_FT2.MP3' ;... Begin Set Command For Show play Time then Play File    *
 *                   Name 'A23_FT1.MP3' is time 30 sec. and chang play File Name               *
 *                   'A24_FT2.MP3' is time 1 minute ,Then Return play New first file           *
 *                                                                                             *
 *                                                                                             *
 * Last Update     : 5/June/2012                                                               *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/



#include <18F8722.h>
#include <stdio.h>

#define TX1   PIN_C6
#define RX1   PIN_C7

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN         //Setup MCU
#use delay (clock = 40000000)                    //delay Clock = (ms)
#use rs232(baud = 9600, xmit = TX1, rcv = RX1)   //Set Rs232

#use fast_io(ALL)                                //Stop Set direction Auto for All Port  by Compiler  


unsigned int8 Buf_Time[5]  ;



//-----------------  Function Initial UART1 --------------------


void UART1_Init(void)
 {
   set_tris_C(0x80)             ;        //Set RX(RC7) = In,TX(RC6)=Out,RC5..RC0 = Out

 }


 

//-------------- Check Echo Command (#OK)----------------

void Echo_Cmm(void)
 {
   int8 buf_cmm[2] ;
   int8 n,ch ;
   
   do
    {
      do
       {
        ch = getc()                              ; //Read data Start Byte
       }while(ch != '#')                         ; //Check Byte Start of Echo cmm('#')

      for(n=0;n<2;n++)                             //if ch = # then Keep cmm 2 byte(Keep 'OK')
       {
         buf_cmm[n] = getc()                     ; //Read Data 'OK' 
       }
     
    }while((buf_cmm[0]!='O')&&(buf_cmm[1]!='K')) ; //Check Echo Command = 'OK' Exit Loop
 }



//----------------- Read Play Time -------------------//
//       Buf_Time[0] = Ascii Minute Byte High         //
//       Buf_Time[1] = Ascii Minute Byte Low          //
//       Buf_Time[2] = Ascii :                        //
//       Buf_Time[3] = Ascii Secound Byte High        //
//       Buf_Time[4] = Ascii Secound Byte Low         //
//----------------------------------------------------//


void RD_Time(void)
 {
    unsigned int8 ch,n ;

      do
       {
         ch = getc()                             ; //Read data Start Byte
       }while(ch !='@')                          ; //Check Byte Start of Echo cmm('@')

      for(n=0;n<5;n++)                             //if ch = @ then Keep data 5 byte(MM:SS)
       {
         Buf_Time[n] = getc()                    ; //Read Data 'MM:SS' 
       }   
 }



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 void main(void)
 {
    unsigned int8 enter=0x0D  ;


    UART1_Init()      ;
    delay_ms(500)     ;  //delay for Sync Borad MP3 Ready 

    //------------------- Begin Sent Command --------------------

   printf("*CF=001%c",enter)     ;   //Sent CMM Config. Play[000] =0:Play Instantly ,0:Play 1 Round ,1: Display Time
   Echo_Cmm()                    ;   //Check CMM'#OK'

   //------------- Loop Play file by Name -----------
     
   while(true)
    {
      printf("*P2=A23_FT1.MP3%c",enter)      ;    //Sent CMM Play File by Name : 'A23_FT1.MP3'
      Echo_Cmm()                             ;    //Check CMM'#OK'
     
      do
       {
         RD_Time()                           ;    //Read Playing Time
        
       }while((Buf_Time[0]!='0')||(Buf_Time[1]!='0')||(Buf_Time[3]!='3')||(Buf_Time[4]!='0'))  ;  //Check Play File to 00.30 sec. Give Chang play File    
        
       printf("*P2=A24_FT2.MP3%c",enter)      ;   //Sent CMM Play File by Name : 'A24_FT2.MP3'
       Echo_Cmm()                             ;   //Check CMM'#OK'

       do
        {
          RD_Time()                            ;   //Read Playing Time
        
        }while((Buf_Time[0]!='0')||(Buf_Time[1]!='1')||(Buf_Time[3]!='0')||(Buf_Time[4]!='0'))  ; //Check Play File to 01.00 minit. Give Chang play File      
   
   
     }  // Return Play File New
 
 }
